const { Telegraf, Markup } = require('telegraf');
const axios = require('axios');
const config = require('./config.js');

const bot = new Telegraf(config.tokenBot);
const { subdomain, ownerId } = config;

const sessions = new Map(); // simpan sementara host|ip

bot.start((ctx) => ctx.reply('Bot subdomain aktif! Ketik /subdomain <host|ip>'));

bot.command('subdomain', (ctx) => {
  const userId = ctx.from.id;
  if (userId.toString() !== ownerId) return ctx.reply('❌ Kamu bukan owner!');

  const args = ctx.message.text.split(' ').slice(1).join(' ');
  if (!args || !args.includes('|')) return ctx.reply('❌ Format: /subdomain host|ip');

  sessions.set(userId, args); // simpan host|ip

  const domains = Object.keys(subdomain);
  const buttons = domains.map((d, i) => [Markup.button.callback(`${i + 1}. ${d}`, `domain_${i + 1}`)]);

  ctx.reply('Pilih domain untuk subdomain:', Markup.inlineKeyboard(buttons));
});

// Handler untuk tombol domain
bot.action(/domain_(\d+)/, async (ctx) => {
  const userId = ctx.from.id;
  if (userId.toString() !== ownerId) return ctx.answerCbQuery('❌ Kamu bukan owner!');

  const data = sessions.get(userId);
  if (!data) return ctx.answerCbQuery('❌ Sesi habis, ulangi /subdomain');

  const [host, ip] = data.split('|');
  const index = parseInt(ctx.match[1]) - 1;
  const domains = Object.keys(subdomain);
  const tldnya = domains[index];

  ctx.answerCbQuery('⏳ Membuat subdomain...');

  async function createSubDomain(host, ip) {
    return axios.post(
      `https://api.cloudflare.com/client/v4/zones/${subdomain[tldnya].zone}/dns_records`,
      {
        type: "A",
        name: host.replace(/[^a-z0-9.-]/gi, "") + "." + tldnya,
        content: ip.replace(/[^0-9.]/gi, ""),
        ttl: 3600,
        proxied: false
      },
      {
        headers: {
          Authorization: `Bearer ${subdomain[tldnya].apitoken}`,
          "Content-Type": "application/json"
        }
      }
    ).then(res => {
      const result = res.data;
      if (result.success) {
        return {
          success: true,
          zone: result.result.zone_name,
          name: result.result.name,
          ip: result.result.content
        };
      } else {
        return { success: false, error: result.errors?.[0]?.message || 'Unknown error' };
      }
    }).catch(err => {
      const msg = err.response?.data?.errors?.[0]?.message || err.message || 'Unknown error';
      return { success: false, error: msg };
    });
  }

  const result = await createSubDomain(host.toLowerCase(), ip);
  sessions.delete(userId); // bersihkan sesi

  if (result.success) {
    ctx.editMessageText(`✅ Subdomain berhasil dibuat!\n\nIP: ${result.ip}\nSubdomain: ${result.name}`);
  } else {
    ctx.editMessageText(`❌ Gagal: ${result.error}`);
  }
});

bot.launch();
console.log('Bot Telegram subdomain berjalan...');